<?php

use App\Http\Controllers\StripeController;
use App\Models\Business;
use App\Models\Event;
use App\Models\PasswordReset;
use App\Models\Question;
use App\Models\Users;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;
use Illuminate\Validation\Rule;
use Stripe\Stripe;
use App\Http\Controllers\AnswerController;
use App\Http\Controllers\QuestionController;
use App\Http\Controllers\UserApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('questions/all/', [QuestionController::class, 'get_all_questions']);
Route::get('chechJoin/', [QuestionController::class, 'chechJoin']);
Route::post('login/token/', [UserApiController::class, 'login']);
Route::post('register/', [UserApiController::class, 'register']);
Route::post('user/password/forgot', [UserApiController::class, 'forgot_password']);
Route::post('user/otp/verify', [UserApiController::class, 'otp_verification']);
Route::post('user/password/reset', [UserApiController::class, 'reset_password']);

Route::group(['middleware' => 'auth:sanctum'], function () {
    Route::get('user/profile', [UserApiController::class, 'get_user_profile']);
    Route::post('user/profile', [UserApiController::class, 'update_user_profile']);
    Route::post('whitelist/user', [UserApiController::class, 'whitelist_user']);
    Route::post('whitelist/check', [UserApiController::class, 'check_whitelist_submission']);
    Route::post('user/subscription', [UserApiController::class, 'user_subscription']);
    Route::get('user/subscription', [UserApiController::class, 'get_user_subscription']);

    Route::post("question", [QuestionController::class, 'add_new_question']);
    Route::get("question", [QuestionController::class, 'get_all_question_by_user']);
    Route::post("answere", [AnswerController::class, 'add_answere_to_question']);
    Route::get("answere", [AnswerController::class, 'get_all_answere_by_user']);

    Route::post("addComments", [QuestionController::class, 'add_Comments']);
    Route::post('questions/{id}/voteup', [QuestionController::class, 'voteUp']);
    Route::post('questions/{id}/votedown', [QuestionController::class, 'voteDown']);
    //  Route::post('questions/{id}/get-votes',[QuestionController::class,'get_Votes']);
    Route::get('questions/{id}/comments', [QuestionController::class, 'getQuestionComments']);
    Route::get('questionsall/{id}/user', [QuestionController::class, 'getUserQuestions']);
    Route::get('question/{id}/{name}', [QuestionController::class, 'getQuestion']);
    Route::get("getAnswers/{question_id}", [AnswerController::class, 'getAnswersOfQuestion']);

    // Question GET By Junaid
    Route::get("questions", [QuestionController::class, 'get_all_question']);
    Route::post("add_question", [QuestionController::class, 'add_question']);
    Route::post("add_options", [QuestionController::class, 'add_options']);
    Route::post("userAnswers", [QuestionController::class, 'add_user_answers']);

    Route::post('createPassword', [UserApiController::class, 'create_password']);
});
Route::get('questions/{id}/user', [QuestionController::class, 'getQuestion']);
