@extends('admin.admin-master-template')
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">
            <div class="container-fluid">
                <div class="page-title-box">
                    <div class="row align-items-center">
                        <div class="col-sm-6">
                            <h4 class="page-title">Options</h4>
                        </div>

                    </div> <!-- end row -->
                </div>
                <!-- end page-title -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card m-b-30">
                            <div class="card-body">
                                <?php
                                $update_id = 0;

                                if (isset($obj->id) && !empty($obj->id)) {
                                    $update_id = $obj->id;
                                }
                                ?>
                                <form class="" action="{{ route('options.submit', $update_id) }}" method="post"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="col-md-6">
                                        <label>Question ID</label>

                                        <select class="form-control" name="question_id" id="question_id">
                                            <option selected value="{!! $obj->question->id ?? '' !!}">
                                                {!! $obj->question->title ?? '' !!}
                                            </option>
                                            @foreach ($getQuestions as $getQuestion)
                                                <option value='{{ $getQuestion->id }}'> {{ $getQuestion->title }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Title</label>
                                            <input type="text" name="title"
                                                value="<?= isset($obj->title) && !empty($obj->title) ? $obj->title : '' ?>"
                                                class="form-control" required placeholder="Type something" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Option type</label>
                                        <select class="form-control" name="type" id="type">
                                            <option value='input'>Input
                                            </option>
                                            <option value='radio'>Radio
                                            </option>
                                            <option value='checkbox'>checkbox
                                            </option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <div>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                Submit
                                            </button>
                                            <button type="reset" class="btn btn-secondary waves-effect m-l-5">
                                                Cancel
                                            </button>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div> <!-- end col -->


                </div> <!-- end row -->


            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->

        <footer class="footer">
            © 2019 - 2020 Stexo <span class="d-none d-sm-inline-block"> - Crafted with <i
                    class="mdi mdi-heart text-danger"></i> by Themesdesign</span>.
        </footer>

    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.1/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-/bQdsTh/da6pkI1MST/rWKFNjaCP5gBSY4sEBT38Q/9RBh9AH40zEOg7Hlq2THRZ" crossorigin="anonymous">
    </script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script>
        $(document).ready(function() {
            $('#category').on('change', function() {
                var categoryID = $(this).val();
                if (categoryID) {
                    $.ajax({
                        url: '/getsubcategory/' + categoryID,
                        type: "GET",
                        data: {
                            "_token": "{{ csrf_token() }}"
                        },
                        dataType: "json",
                        success: function(data) {
                            if (data) {
                                $('#subcategory').empty();
                                $('#subcategory').append(
                                    '<option hidden>Choose subcategory</option>');
                                $.each(data, function(key, subcategory) {
                                    $('select[name="subcategory"]').append(
                                        '<option value="' + subcategory.id + '">' +
                                        subcategory
                                        .subcategory_name + '</option>');
                                });
                            } else {
                                $('#subcategory').empty();
                            }
                        }
                    });
                } else {
                    $('#subcategory').empty();
                }
            });
        });
    </script>
    <!-- ============================================================== -->
    <!-- End Right content here -->
    <!-- ============================================================== -->
@endsection
