<?php

namespace App\Http\Controllers;

use App\Models\Answer;
use App\Models\Comment;
use Illuminate\Http\Request;
use App\Models\Question;
use App\Models\Users;
use App\Models\Vote;
use Illuminate\Support\Facades\Auth;
use LDAP\Result;
use Illuminate\Support\Facades\DB;


class QuestionController extends Controller
{
    public function add(Request $request)
    {
        //  return  $login = User::find(auth()->user()->id);

        json_encode(Auth::user());
        $user = Users::find(auth()->user()->id);

        //  dd(Auth::user()->id);
        //  return 0;
        //   return  $login = auth::user()->id;
        $Question = new Question();
        $Question->tittle = $request->tittle;
        $Question->slug = $request->slug;
        $Question->body = $request->body;
        $Question->views = $request->views;
        $Question->answers = $request->answers;
        $Question->best_answer_id = $request->best_answer_id;
        $Question->user_id = $user->id;
        // return $Question;
        $result = $Question->save();
        if ($result) {
            return ["Result" => "success"];
        } else {
            return ["Result" => "Error"];
        }
    }

    public function add_Comments(Request $request)
    {
        json_encode(Auth::user());
        $user = Users::find(auth()->user()->id);
        //  $Question =  Question::find($id);
        //  $Question= Question::find($request->question_id);
        //  return $Question;
        $comment = new Comment();
        $comment->body = $request->body;
        $comment->user_id = $user->id;
        $comment->question_id = $request->question_id;
        $result = $comment->save();
        if ($result) {
            return ["Result" => "success"];
        } else {
            return ["Result" => "Error"];
        }
    }

    public function voteDown(Request $request, $id)
    {
        $question = Question::where('id', $id)->first();
        if (!$question) {
            return json_encode([
                "result" => false,
                "message" => "Question does not Exists!"
            ]);
        }
        requestValidate($request, [
            "answer_id" => "required"
        ]);
        $answer = Answer::where('id', $request->answer_id)->first();
        if (!$answer) {
            return json_encode([
                "result" => false,
                "message" => "Answer does not Exists!"
            ]);
        }
        try {
            $result=true;
            $vote = Vote::where([
                'user_id' => auth()->user()->id,
                'answer_id' => $request->answer_id
            ])->get();
            if ($vote && count($vote)) {
                Vote::where([
                    'user_id' => auth()->user()->id,
                    'answer_id' => $request->answer_id
                ])->delete();
                $msg = "down vote has been removed.";
            } elseif (!$vote || count($vote) < 1) {
                $vote = new Vote();
                $vote->vote = "-1";
                $vote->user_id = auth()->user()->id;
                $vote->answer_id = $request->answer_id;
                $vote->save();
                $msg = "down vote has been voted.";
            }
            $update_Votes=self::update_Votes($request->answer_id);

            return json_encode([
                "result" => $result,
                "message" => $msg
            ]);
        } catch (\Exception $e) {
            return json_encode([
                "result" => false,
                "message" => "Something wrong"
            ]);
        }
    }

    public function voteUp(Request $request, $id)
    {
        $question = Question::where('id', $id)->first();
        if (!$question) {
            return json_encode([
                "result" => false,
                "message" => "Question does not Exists!"
            ]);
        }
        requestValidate($request, [
            "answer_id" => "required"
        ]);
        $answer = Answer::where('id', $request->answer_id)->first();
        if (!$answer) {
            return json_encode([
                "result" => false,
                "message" => "Answer does not Exists!"
            ]);
        }
        try {
            $result=true;
            $vote = Vote::where([
                'user_id' => auth()->user()->id,
                'answer_id' => $request->answer_id
            ])->get();
            if ($vote && count($vote)) {
                Vote::where([
                    'user_id' => auth()->user()->id,
                    'answer_id' => $request->answer_id
                ])->delete();
                $msg = "Up vote has been removed.";
            } elseif (!$vote || count($vote) < 1) {
                $vote = new Vote();
                $vote->vote = "+1";
                $vote->user_id = auth()->user()->id;
                $vote->answer_id = $request->answer_id;
                $vote->save();
                $msg = "Up vote has been voted.";
            }
            $update_Votes=self::update_Votes($request->answer_id);
            return json_encode([
                "result" => $result,
                "message" => $msg
            ]);
        } catch (\Exception $e) {
            return json_encode([
                "result" => false,
                "message" => "Something wrong"
            ]);
        }
    }

    static function update_Votes($answer_id){
        $upvotes =  Vote::where([
            'answer_id' => $answer_id,
            'vote' => "+1",
        ])->count();


        $downvotes = Vote::where([
            'answer_id' => $answer_id,
            'vote' => "-1",
        ])->count();

        $votes= $upvotes - $downvotes;
        $answer = Answer::where('id', $answer_id)->update([
            'votes'=> $votes,
        ]);
        return isset($answer)?true:false;
    }

    public function get_Votes($id)
    {
        $question = Question::where('id', $id)->first();
        if (!$question) {
            return json_encode([
                "result" => false,
                "message" => "Question does not Exists!"
            ]);
        }

        $answers = Answer::where('question_id', $id)->get();

        $data = array();
        foreach ($answers as $answer) {
            $upvotes =  Vote::where([
                 'user_id' => auth()->user()->id,
                'answer_id' => $answer->id,
                'vote' => "+1",
            ])->count();


            $downvotes = Vote::where([
                 'user_id' => auth()->user()->id,
                'answer_id' => $answer->id,
                'vote' => "-1",
            ])->count();

            $data['answers'][$answer->id]['votes']= $upvotes - $downvotes;
        }


        return response()->json(['status' => true, 'message' => "Success", 'data' => $data]);
    }


    public function getUserQuestions($id)
    {
        $date=Question::show($id);


        return response()->json($date);

    }
// still
    public function getQuestion($id)
    {
        $data=array();
        $data['question']=DB::table('questions')->where('questions.id',$id)
        ->first();
        $data['answers']=DB::table('answers')->where('answers.question_id',$id)
            ->select('answers.*')
            ->get();
        return response()->json($data);

    }

    public function getQuestionComments($id)
    {
        $date=Question::Question($id);
        // dd($data);
         return response()->json($date);
    }
}

