<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User;

class UserAnswer extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'question_id',
        'option_id',
        'answer'
    ];

    public function user()
    {
        return $this->belongsTo(Users::class,  'user_id', 'id');
    }
    public function question()
    {
        return $this->belongsTo(Question::class,  'question_id', 'id');
    }
    public function option()
    {
        return $this->hasMany(Option::class,  'option_id', 'id');
    }
}
