<?php

namespace App\Http\Controllers;

use App\Models\Users;
use App\Models\PasswordReset;
use App\Models\Subscription;
use Illuminate\Support\Facades\Hash;

use Illuminate\Http\Request;

class UserApiController extends Controller
{
    //
    function login(Request $request)
    {
        requestValidate($request, [
            "email" => "required|email|exists:users,email",
            "password" => "required"
        ]);

        $user = Users::where('email', $request->email)->first();
        if (!$user)
            return response(['status' => false, 'message' => 'Email address does not exist'], 200);

        if (!Hash::check($request->password, $user->password))
            return response(['status' => false, 'message' => 'Invalid email or password. Please try again'], 200);


        return ['code' => 200, 'status' => true, 'message' => 'Login Successfully', 'data' => $user, 'access_token' => $user->createToken($request->email)->plainTextToken];
    }

    function register(Request $request)
    {
        requestValidate($request, [
            "email" => "required|email|unique:users",
            "name" => "required",
            "password" => "required",
            "username" => "required|unique:users,username",


        ]);

        $user = new Users;
        $user->name = $request->name;
        $user->email = $request->email;
        $user->gender = $request->gender;
        $user->dob = $request->dob;
        $user->username = $request->username;
        $user->invitation_code = $request->invitation_code;

        $user->password = Hash::make($request->password);
        // $user->image = $request->name;

        if ($request->file()) {
            $imageName = rand(9, 99999) . '.' . $request->image->extension();
            $request->image->move(public_path('uploads/user'), $imageName);
            $user->image = $imageName;
        }
        $user->save();

        return ['status' => true, 'message' => 'User Register Successfully', 'data' => $user, 'access_token' => $user->createToken($request->email)->plainTextToken];
    }

    function forgot_password(Request $request)
    {
        requestValidate($request, [
            "email" => "required|email|exists:users,email"

        ]);

        $user = Users::where('email', $request->email)->first();
        if ($user) {
            $token = rand(0, 9999);
            PasswordReset::insert([
                'email' => $user->email,
                'token' => $token
            ]);
            Mail::send('mails.forgot-password', ['user' => $user, 'token' => $token], function ($m) use ($user, $token) {
                $m->from('forgot@app.com', 'Das Wunder');

                $m->to($user->email, $user->name)->subject('Forgot Password Token');
            });


            return ['status' => true, 'message' => 'OTP has been sent on your Email please check your inbox, also check spam list'];
        } else {

            return ['status' => false, 'message' => "The Email you provided doesn't belong to any account"];
        }

        return ['status' => true, 'message' => 'OTP has been sent on your Email please check your inbox, also check spam list'];
    }
    function login_registry_step_1(Request $request)
    {

        requestValidate($request, [
            "email" => "required"

        ]);

        $user = Users::where('email', $request->email)->first();
        if ($user) {
            return ['status' => true, 'message' => 'Email Verified Successfully', 'data' => $user, 'access_token' => $user->createToken($request->email)->plainTextToken];
        } else {

            return ['status' => false, 'message' => 'The Email you provided does not exist'];
        }
    }
    function otp_verification(Request $request)
    {

        requestValidate($request, [
            "token" => "required",
            "email" => "required"

        ]);

        $token = PasswordReset::where('token', $request->token)->first();
        if ($token) {
            Users::where('email', $token->email)->update([
                'is_verified' => 1
            ]);
            PasswordReset::where('token', $request->token)->delete();

            $user = Users::where('email', $request->email)->first();
            return ['code' => 200, 'status' => true, 'message' => 'Registered Successfully', 'data' => $user, 'access_token' => $user->createToken($request->email)->plainTextToken];
        } else {

            return ['status' => false, 'message' => 'Invalid OTP'];
        }
    }

    function reset_password(Request $request)
    {
        requestValidate($request, [
            "token" => "required",
            "password" => "required"

        ]);

        $token = PasswordReset::where('token', $request->token)->first();
        if ($token) {
            Users::where('email', $token->email)->update([
                'password' => Hash::make($request->password)
            ]);
            PasswordReset::where('token', $request->token)->delete();
            $user = Users::where('email', $token->email)->first();

            return ['status' => true, 'message' => 'Password Reset Successfully', 'data' => $user, 'access_token' => $user->createToken($token->email)->plainTextToken];
        } else {

            return ['status' => true, 'message' => 'Invalid OTP'];
        }
    }

    function get_user_profile(Request $request)
    {
        header("Access-Control-Allow-Origin");
        $user =  auth()->user();
        $user['access_token'] = $user->createToken($user->email)->plainTextToken;
        return ['code' => 200, 'status' => true, 'message' => 'User Profile Information', 'data' => $user];
    }

    function update_user_profile(Request $request)
    {

        $user = Users::find(auth()->user()->id);
        $user->name = $request->name;
        if ($request->file()) {
            $imageName = rand(9, 99999) . '.' . $request->image->extension();
            $request->image->move(public_path('uploads/user'), $imageName);
            $user->image = $imageName;
        }
        $user->save();

        return ['status' => true, 'message' => 'Profile Updated Successfully', 'data' => $user];
    }

    public function whitelist_user(Request $request)
    {
        header("Access-Control-Allow-Origin");
        $user = Users::find(auth()->user()->id);
        $user->wallet_address = $request->wallet_address;
        $user->is_whitelist = 1;
        $user->save();
        return ['status' => true, 'message' => 'User Whitelist Successfully', 'data' => $user, 'access_token' => $user->createToken($user->email)->plainTextToken];
    }
    function check_whitelist_submission(Request $request)
    {
        $user = Users::find(auth()->user()->id);

        if ($user->is_whitelist == 1) {
            return ['status' => true, 'message' => 'Already whitelisted', 'data' => $user];
        } else {
            return ['status' => true, 'message' => 'Please submit your wallet address to be whitelist'];
        }
    }

    function get_user_subscription(Request $request)
    {
        $user = Subscription::where('user_id', auth()->user()->id)->first();

        if ($user) {
            return ['status' => true, 'message' => 'Already Subscribed', 'data' => $user];
        } else {
            return ['status' => false, 'message' => 'Please pay the subscription'];
        }
    }


    function user_subscription(Request $request)
    {
        requestValidate($request, [
            "token" => "required",
            "to_wallet" => "required",
            "amount" => "required",
            "from_wallet" => "required",
            "to_wallet" => "required",


        ]);
        $user = Users::find(auth()->user()->id);
        if ($user->is_whitelist == 1) {
            $subscription = new Subscription;
            $subscription->date = date('Y-m-d');
            $subscription->user_id = $user->id;
            $subscription->token = $request->token;
            $subscription->contract_address = $request->contract_address;
            $subscription->type = $request->type ?? 'monthly';
            $subscription->amount = $request->amount;
            $subscription->from_wallet = $request->from_wallet;
            $subscription->to_wallet = $request->to_wallet;
            $subscription->save();
            return ['status' => true, 'message' => 'Successfully Subscribed', 'data' => $subscription];
        } else {
            return ['status' => true, 'message' => 'In order to pay subscription you need to be whitelist first'];
        }
    }

    // Work BY JUNAID
    function create_password(Request $request)
    {
        requestValidate($request, [
            "username" => "required",
            "newpassword" => "required",
            // "oldPassword" => "required"

        ]);
        $auth = auth()->user()->username;
        $user = Users::where('username', $request->username)->first();
        if (!$user)
            return response(['status' => false, 'message' => 'username address does not exist'], 200);

        // if (!Hash::check($request->oldPassword, $user->password))
        //     return response(['status' => false, 'message' => 'Invalid email or password. Please try again'], 200);
        if ($auth == $user)
            $user->update([
                'password' => Hash::make($request->newpassword)
            ]);
        return ['status' => true, 'message' => 'Password updated Successfully',];
    }
}
