<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Session;
use Stripe;
    
class StripeController extends Controller
{
    //

     /**
     * success response method.
     *
     * @return \Illuminate\Http\Response
     */
    public function stripePost(Request $request)
    {
        \Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
        $session = \Stripe\Checkout\Session::create([
            'payment_method_types' => ['card'],
            'line_items' => [
                [
                    'price_data' => [
                    'currency' => '$',
                    'product_data' => [
                        'name' => "Payment"
                    ],
                    'unit_amount' => $request->amount*100,
                    ],
                    'quantity' => 1,
                    ]
                ],
            'mode' => 'payment',
            'success_url' => route('stripe.success'),
            'cancel_url' => route('stripe.cancel'),
        ]);
    }

    public function stripe_success($id){
        return ['status'=>true,'business_id' => $id];

    }
    public function stripe_cancel(){
        
    }
}
