<?php

namespace App\Http\Controllers;

use App\Models\Answer;
use App\Models\Comment;
use App\Models\Option;
use Illuminate\Http\Request;
use App\Models\Question;
use App\Models\UserAnswer;
use App\Models\Users;
use App\Models\Vote;
use GuzzleHttp\Promise\Create;
use Illuminate\Support\Facades\Auth;
use LDAP\Result;
use Illuminate\Support\Facades\DB;

use function PHPUnit\Framework\isEmpty;

class QuestionController extends Controller
{
    public function add_new_question(Request $request)
    {
        header("Access-Control-Allow-Origin");
        $Question = new Question();
        $Question->tittle = $request->tittle;
        $Question->body = $request->body;
        $Question->user_id = Auth::user()->id;
        $result = $Question->save();
        if ($result) {
            return response()->json([
                "status" => true,
                "message" => "Data added successfully"
            ]);
        } else {
            return response()->json([
                "status" => false,
                "message" => "Unknown Error Occur"
            ]);
        }
    }


    public function add_Comments(Request $request)
    {
        header("Access-Control-Allow-Origin");
        json_encode(Auth::user());
        $user = Users::find(auth()->user()->id);
        //  $Question =  Question::find($id);
        //  $Question= Question::find($request->question_id);
        //  return $Question;
        $comment = new Comment();
        $comment->body = $request->body;
        $comment->user_id = $user->id;
        $comment->question_id = $request->question_id;
        $result = $comment->save();
        if ($result) {
            return json_encode([
                "status" => true,
                "message" => "Data added successfully"
            ]);
        } else {
            return json_encode([
                "status" => false,
                "message" => "Error"
            ]);
        }
    }

    public function voteDown(Request $request, $id)
    {
        header("Access-Control-Allow-Origin");
        $question = Question::where('id', $id)->first();
        if (!$question) {
            return json_encode([
                "result" => false,
                "message" => "Question does not Exists!"
            ]);
        }
        requestValidate($request, [
            "answer_id" => "required"
        ]);
        $answer = Answer::where('id', $request->answer_id)->first();
        if (!$answer) {
            return json_encode([
                "result" => false,
                "message" => "Answer does not Exists!"
            ]);
        }
        try {
            $result = true;
            $vote = Vote::where([
                'user_id' => auth()->user()->id,
                'answer_id' => $request->answer_id
            ])->get();
            if ($vote && count($vote)) {
                Vote::where([
                    'user_id' => auth()->user()->id,
                    'answer_id' => $request->answer_id
                ])->delete();
                $msg = "down vote has been removed.";
            } elseif (!$vote || count($vote) < 1) {
                $vote = new Vote();
                $vote->vote = "-1";
                $vote->user_id = auth()->user()->id;
                $vote->answer_id = $request->answer_id;
                $vote->save();
                $msg = "down vote has been voted.";
            }
            $update_Votes = self::update_Votes($request->answer_id);

            return json_encode([
                "result" => $result,
                "message" => $msg
            ]);
        } catch (\Exception $e) {
            return json_encode([
                "result" => false,
                "message" => "Something wrong"
            ]);
        }
    }

    public function voteUp(Request $request, $id)
    {
        header("Access-Control-Allow-Origin");
        $question = Question::where('id', $id)->first();
        if (!$question) {
            return json_encode([
                "result" => false,
                "message" => "Question does not Exists!"
            ]);
        }
        requestValidate($request, [
            "answer_id" => "required"
        ]);
        $answer = Answer::where('id', $request->answer_id)->first();
        if (!$answer) {
            return json_encode([
                "result" => false,
                "message" => "Answer does not Exists!"
            ]);
        }
        try {
            $result = true;
            $vote = Vote::where([
                'user_id' => auth()->user()->id,
                'answer_id' => $request->answer_id
            ])->get();
            if ($vote && count($vote)) {
                Vote::where([
                    'user_id' => auth()->user()->id,
                    'answer_id' => $request->answer_id
                ])->delete();
                $msg = "Up vote has been removed.";
            } elseif (!$vote || count($vote) < 1) {
                $vote = new Vote();
                $vote->vote = "+1";
                $vote->user_id = auth()->user()->id;
                $vote->answer_id = $request->answer_id;
                $vote->save();
                $msg = "Up vote has been voted.";
            }
            $update_Votes = self::update_Votes($request->answer_id);
            return json_encode([
                "result" => $result,
                "message" => $msg
            ]);
        } catch (\Exception $e) {
            return json_encode([
                "result" => false,
                "message" => "Something wrong"
            ]);
        }
    }

    static function update_Votes($answer_id)
    {
        header("Access-Control-Allow-Origin");
        $upvotes =  Vote::where([
            'answer_id' => $answer_id,
            'vote' => "+1",
        ])->count();


        $downvotes = Vote::where([
            'answer_id' => $answer_id,
            'vote' => "-1",
        ])->count();

        $votes = $upvotes - $downvotes;
        $answer = Answer::where('id', $answer_id)->update([
            'votes' => $votes,
        ]);
        return isset($answer) ? true : false;
    }

    public function get_Votes($id)
    {
        header("Access-Control-Allow-Origin");
        $question = Question::where('id', $id)->first();
        if (!$question) {
            return json_encode([
                "result" => false,
                "message" => "Question does not Exists!"
            ]);
        }

        $answers = Answer::where('question_id', $id)->get();

        $data = array();
        foreach ($answers as $answer) {
            $upvotes =  Vote::where([
                'user_id' => auth()->user()->id,
                'answer_id' => $answer->id,
                'vote' => "+1",
            ])->count();


            $downvotes = Vote::where([
                'user_id' => auth()->user()->id,
                'answer_id' => $answer->id,
                'vote' => "-1",
            ])->count();

            $data['answers'][$answer->id]['votes'] = $upvotes - $downvotes;
        }


        return response()->json(['status' => true, 'message' => "Success", 'data' => $data]);
    }


    public function getUserQuestions($id)
    {
        header("Access-Control-Allow-Origin");
        $date = Question::show($id);
        if ($date->isEmpty()) {

            return json_encode([
                "status" => false,
                "message" => "Questions not found"
            ]);
        } else {

            return response()->json($date);
        }

        // return response()->json($date);

    }

    // still
    public function getQuestion($id)
    {
        header("Access-Control-Allow-Origin");
        $data = array();
        // $data['question']=DB::table('questions')->where('questions.id',$id)
        // ->first();
        // $data['answers']=DB::table('answers')->where('answers.question_id',$id)
        //     ->select('answers.*')
        //     ->get();

        $temp = Question::where('id', $id)->with('user')->with('answere.user')->orderBy('id', 'desc')->first();

        if ($temp) {
            return response()->json(['status' => true, 'message' => 'Question Detail', 'data' => $temp]);
        } else {

            return response()->json(['status' => false, 'message' => 'Question Detail Not Found']);
        }
    }

    public function getQuestionComments($id)
    {
        header("Access-Control-Allow-Origin");
        $date = Question::Question($id);
        // dd($data);
        if ($date->isEmpty()) {

            return json_encode([
                "status" => false,
                "message" => "There is no Comments in this Questison!"
            ]);
        } else {

            return response()->json($date);
        }
    }

    //get all questions for homepage ...
    public function get_all_questions()
    {
        header("Access-Control-Allow-Origin");

        $temp = Question::with('user')->with('answere.user')->orderBy('id', 'desc')->paginate(5);

        if ($temp->isEmpty()) {
            return json_encode([
                "status" => false,
                "message" => "Questions not found"
            ]);
        } else {
            return response()->json(['status' => true, 'message' => "All Questions List", 'data' => $temp]);
        }
    }
    //get all questions for homepage ...
    public function get_all_question_and_answers_by_user()
    {
        header("Access-Control-Allow-Origin");

        $tempQuestion = Question::where('user_id', Auth::user()->id)->orderBy('id', 'desc')->paginate(5);
        $tempAns = Answer::where('user_id', Auth::user()->id)->orderBy('id', 'desc')->paginate(5);

        return response()->json(['status' => true, 'message' => "All Questions and Answer List", 'data' => array('questions' => $tempQuestion, 'answers' => $tempAns)]);
    }
    //get all questions for homepage ...
    public function get_all_question_by_user()
    {
        header("Access-Control-Allow-Origin");

        $temp = Question::where('user_id', Auth::user()->id)->orderBy('id', 'desc')->paginate(5);

        if ($temp->isEmpty()) {
            return json_encode([
                "status" => false,
                "message" => "Questions not found"
            ]);
        } else {
            return response()->json(['status' => true, 'message' => "All Questions List", 'data' => $temp]);
        }
    }

    public function chechJoin()
    {
        header("Access-Control-Allow-Origin");
        $date = DB::table('questions')
            ->join('users', 'questions.user_id', '=', 'users.id')
            ->select('questions.*', 'users.name')
            ->get();
        if ($date->isEmpty()) {

            return json_encode([
                "status" => false,
                "message" => "Questions not found"
            ]);
        } else {

            return response()->json($date);
        }

        // return response()->json($date);

    }

    // GET QUESTIONS BY JUNAID
    public function get_all_question(Request $request)
    {
        header("Access-Control-Allow-Origin");
        $question = Question::with('option')->orderBy('id', 'asc')->skip($request->offset)->take($request->limit)->get();

        if ($question->isEmpty()) {
            return json_encode([
                "status" => false,
                "message" => "Questions not found"
            ]);
        } else {
            return response()->json(['status' => true, 'message' => "All Questions List", 'data' => $question]);
        }
    }

    public function add_user_answers(Request $request)
    {
        $user_id = Auth::user()->id;
        $answers = $request->answers;

        foreach ($answers as $answer) {
            foreach ((array) $answer['option_id'] as $option) {
                $data = UserAnswer::create([
                    'user_id' => $user_id,
                    'question_id' => $answer['question_id'],
                    'option_id' => $option,
                    'answer' => $answer['answer'],
                ]);
            };
        }

        $update = Users::where('id', $user_id)->update([
            'is_questionare_complete' => 1,
        ]);


        return response()->json(['status' => true, 'message' => "Your answers has been submited"]);
    }

    public function add_question(Request $request)
    {
        // $Question = new Question();
        // $Question->title = $request->title;
        // $result = $Question->save();


        // $answers = $request->answers;
        // foreach ((array) $answers['Otitle'] as $option) {
        //     $obj = Question::create([
        //         'title' => $request->$answers['Qtitle'],
        //     ]);
        // }

        // foreach ((array) $answers['Otitle'] as $option) {
        //     $obj->option()->create([
        //         'title' => $option,
        //     ]);
        // }


        // $obj->ProductVarients()->create([
        //     'question_id' => $request['question_id'],
        //     'title' => $request,
        // ]);
        $options = $request->otitle;

        $question = Question::create([
            'title' => $request->qtitle,
        ]);
        foreach ($options as $option) {
            $question->option()->create([
                "title" => $option,
            ]);
        }
        // similar for other relations

        return response()->json('The question successfully added');
    }
    //     if ($obj) {
    //         return response()->json([
    //             "status" => true,
    //             "message" => "Data added successfully"
    //         ]);
    //     } else {
    //         return response()->json([
    //             "status" => false,
    //             "message" => "Unknown Error Occur"
    //         ]);
    //     }
    // }
    public function add_options(Request $request)
    {
        $answers = $request->answers;

        foreach ($answers as $answer) {
            foreach ((array) $answer['title'] as $option) {
                $data = Option::create([
                    'question_id' => $answer['question_id'],
                    'title' => $option,
                ]);
            };
        }
        return response()->json(['status' => true, 'message' => "Your answers has been submited"]);
    }
}
