<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Question;
use App\Models\Answer;
use App\Models\Users;
use Illuminate\Support\Facades\Auth;
use LDAP\Result;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\Rule;
class AnswerController extends Controller
{
     public function add_answere_to_question(Request $request)
    {
        header("Access-Control-Allow-Origin");
        $answere = new Answer();
        $answere->answer = $request->answer;
        $answere->question_id = $request->question_id;
        $answere->user_id = Auth::user()->id;
        Question::where('id', $request->question_id)
            ->update([
              'answers'=> DB::raw('answers+1'), 
            ]);
        $result = $answere->save();
        if ($result) {
        return response()->json([
                "status" =>true,
                "message" =>"Data added successfully"
            ]);
        } else {
            return response()->json([
                "status" =>false,
                "message" =>"Unknown Error Occur"
            ]);
        }
    }
      public function get_all_answere_by_user()
    {
        header("Access-Control-Allow-Origin");
        
        $temp = Answer::where('user_id',Auth::user()->id)->orderBy('id', 'desc')->paginate(5);
        
        if($temp->isEmpty())
        {
            return json_encode([
                "status" => false,
                "message" => "Answer not found"
            ]);
        }else{
            return response()->json(['status'=>true,'message'=>"All Answer List",'data'=>$temp]);
        }

    }
        public function getAnswersOfQuestion($questionId)
    {
        header("Access-Control-Allow-Origin");
        $data=Answer::where('question_id', $questionId)->get();
        if($data->isEmpty())
        {

            return json_encode([
                "status" => false,
                "message" => "Questions not found",
                "data"=>[]
            ]);
        }else{
            $dataToSend = [
                "status"=>true,
                "message"=>"Data Found Successfully",
                "data"=>$data
                ];

            return response()->json($dataToSend);
        }

        // return response()->json($date);

    }
}
