<?php

namespace App\Http\Controllers;

use App\Models\Answer;
use App\Models\Book;
use App\Models\BookChapter;
use App\Models\Category;
use App\Models\Content;
use App\Models\Language;
use App\Models\PushNotification;
use App\Models\Slider;
use App\Models\Users;
use App\Models\Business;
use App\Models\Option;
use App\Models\Question;
use App\Models\UserAnswer;
use App\Models\Vacancy;
use Illuminate\Foundation\Auth\User;
use Illuminate\Support\Facades\Hash;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{
    //
    function index()
    {
        return view('admin.pages.dashboard.dashboard');
    }
    public function user_list()
    {

        $obj = Users::where('id', '!=', auth()->user()->id)->where('role', '!=', 'user')->get();
        return view('admin.pages.user.index', compact('obj'));
    }
    public function user_create($id)
    {
        $obj = array();
        if (isset($id) && !empty($id)) {
            $obj = Users::whereId($id)->first();
        }
        return view('admin.pages.user.form', compact('obj'));
    }
    public function user_detail(Request $req)
    {
        $obj = Users::whereId($req->id)->first();
        echo view('admin.pages.user.detail', compact('obj'));
    }
    public function user_destroy(Request $req)
    {
        Users::whereId($req->id)->delete();
        echo 1;
    }
    public function user_submit(Request $req, $id)
    {
        $imageUpdateId = $id;
        if (isset($id) && !empty($id)) {
            Users::whereId($id)->update([
                'name' => $req->name,
                'email' => $req->email,
                'phone' => $req->phone,
                'address' => $req->address,
            ]);
        } else {
            //Create
            $obj = Users::create([
                'name' => $req->name,
                'email' => $req->email,
                'role' => 'admin',
                'phone' => $req->phone,
                'address' => $req->address,
                'password' => Hash::make($req->password),

            ]);
            $imageUpdateId = $obj->id;
        }
        if ($req->file()) {
            $imageName = time() . '.' . $req->image->extension();
            $req->image->move(public_path('uploads/user'), $imageName);
            Users::whereId($imageUpdateId)->update([
                'image' => $imageName
            ]);
        }
        return redirect(route('user.list'));
    }


    // Questions
    public function questions_list()
    {
        $obj = Question::all();
        return view('admin.pages.questions.index', compact('obj'));
    }
    public function questions_create($id)
    {
        $obj = array();
        if (isset($id) && !empty($id)) {
            $obj = Question::whereId($id)->first();
        }
        return view('admin.pages.questions.form', compact('obj'));
    }
    public function questions_detail(Request $req)
    {
        $obj = Question::whereId($req->id)->first();
        echo view('admin.pages.questions.detail', compact('obj'));
    }
    public function questions_destroy(Request $req)
    {
        Question::whereId($req->id)->delete();
        echo 1;
    }
    public function questions_submit(Request $req, $id)
    {
        if (isset($id) && !empty($id)) {
            Question::whereId($id)->update([
                'title' => $req->title
            ]);
        } else {
            //Create
            $obj = Question::create([
                'title' => $req->title,
            ]);
        }

        return redirect(route('questions.list'));
    }


    // Options
    public function options_list()
    {
        $obj = Option::all();
        return view('admin.pages.options.index', compact('obj'));
    }
    public function options_create($id)
    {
        $obj = array();
        if (isset($id) && !empty($id)) {
            // $obj = Option::whereId($id)->first();
            $obj = Option::whereId($id)->with('question')->first();
        }
        $getQuestions = Question::all();
        return view('admin.pages.options.form', compact('obj', 'getQuestions'));
    }
    public function options_detail(Request $req)
    {
        $obj = Option::whereId($req->id)->first();
        echo view('admin.pages.options.detail', compact('obj'));
    }
    public function options_destroy(Request $req)
    {
        Option::whereId($req->id)->delete();
        echo 1;
    }
    public function options_submit(Request $req, $id)
    {

        if (isset($id) && !empty($id)) {
            Option::whereId($id)->update([
                'question_id' => $req->question_id,
                'title' => $req->title,
                'type' => $req->type
            ]);
        } else {
            //Create
            $obj = Option::create([
                'question_id' => $req->question_id,
                'title' => $req->title,
                'type' => $req->type
            ]);
        }

        return redirect(route('options.list'));
    }

    // Answers
    public function answers_list()
    {
        $user = auth()->user()->id;
        $obj = Users::where('is_questionare_complete', 1)->get();
        return view('admin.pages.answers.index', compact('obj'));
    }
    public function answers_create($id)
    {
        $obj = array();
        if (isset($id) && !empty($id)) {
            // $obj = Answer::whereId($id)->first();
            $obj = UserAnswer::whereId($id)->with('question')->first();
        }
        $getQuestions = Question::all();
        return view('admin.pages.answers.form', compact('obj', 'getQuestions'));
    }
    public function answers_detail(Request $req)
    {
        $getQuestion = UserAnswer::where('user_id', $req->id)->with('user')->distinct()->get('question_id');
        $obj = UserAnswer::where('user_id', $req->id)->with('user', 'question')->get();
        // $obj = UserAnswer::whereId($req->id)->get();
        echo view('admin.pages.answers.detail', compact('obj', 'getQuestion'));
    }
    public function answers_destroy(Request $req)
    {
        UserAnswer::whereId($req->id)->delete();
        echo 1;
    }
    public function answers_submit(Request $req, $id)
    {
        $user = auth()->user()->id;
        if (isset($id) && !empty($id)) {
            UserAnswer::whereId($id)->update([
                'user_id' => $user,
                'question_id' => $req->question_id,
                'option_id' => $req->option_id,
                'answer' => $req->answer
            ]);
        } else {
            //Create
            $obj = UserAnswer::create([
                'user_id' => $user,
                'question_id' => $req->question_id,
                'option_id' => $req->option_id,
                'answer' => $req->answer
            ]);
        }

        return redirect(route('answers.list'));
    }

    public function category_list()
    {
        $obj = Category::all();
        return view('admin.pages.category.index', compact('obj'));
    }
    public function category_create($id)
    {
        $obj = array();
        if (isset($id) && !empty($id)) {
            $obj = Category::whereId($id)->first();
        }
        return view('admin.pages.category.form', compact('obj'));
    }
    public function category_detail(Request $req)
    {
        $obj = Category::whereId($req->id)->first();
        echo view('admin.pages.category.detail', compact('obj'));
    }
    public function category_destroy(Request $req)
    {
        Category::whereId($req->id)->delete();
        echo 1;
    }
    public function category_submit(Request $req, $id)
    {
        $imageUpdateId = $id;
        if (isset($id) && !empty($id)) {
            Category::whereId($id)->update([
                'name' => $req->name
            ]);
        } else {
            //Create
            $obj = Category::create([
                'name' => $req->name,
            ]);
            $imageUpdateId = $obj->id;
        }
        if ($req->file()) {
            $imageName = time() . '.' . $req->image->extension();
            $req->image->move(public_path('uploads/categories'), $imageName);
            Category::whereId($imageUpdateId)->update([
                'image' => $imageName
            ]);
        }
        return redirect(route('category.list'));
    }


    //slider
    public function slider_list()
    {
        $obj = Slider::all();
        return view('admin.pages.slider.index', compact('obj'));
    }
    public function slider_create($id)
    {
        $obj = array();
        if (isset($id) && !empty($id)) {
            $obj = Slider::whereId($id)->first();
        }
        return view('admin.pages.slider.form', compact('obj'));
    }
    public function slider_detail(Request $req)
    {
        $obj = Slider::whereId($req->id)->first();
        echo view('admin.pages.slider.detail', compact('obj'));
    }
    public function slider_destroy(Request $req)
    {
        Slider::whereId($req->id)->delete();
        echo 1;
    }
    public function slider_submit(Request $req, $id)
    {
        $imageUpdateId = $id;
        if (isset($id) && !empty($id)) {
            Slider::whereId($id)->update([

                'url' => $req->url,
            ]);
        } else {
            //Create
            $obj = Slider::create([

                'url' => $req->url,
            ]);
            $imageUpdateId = $obj->id;
        }
        if ($req->file()) {
            $imageName = time() . '.' . $req->image->extension();
            $req->image->move(public_path('uploads/slider'), $imageName);
            Slider::whereId($imageUpdateId)->update([
                'image' => $imageName
            ]);
        }
        return redirect(route('slider.list'));
    }


    //Language
    public function language_list()
    {
        $obj = Language::all();
        return view('admin.pages.language.index', compact('obj'));
    }
    public function language_create($id)
    {
        $obj = array();
        if (isset($id) && !empty($id)) {
            $obj = Language::whereId($id)->first();
        }
        return view('admin.pages.language.form', compact('obj'));
    }
    public function language_detail(Request $req)
    {
        $obj = Language::whereId($req->id)->first();
        return view('admin.pages.language.detail', compact('obj'));
    }
    public function language_destroy(Request $req)
    {
        Language::whereId($req->id)->delete();
        echo 1;
    }
    public function language_submit(Request $req, $id)
    {
        $imageUpdateId = $id;
        if (isset($id) && !empty($id)) {
            Language::whereId($id)->update([
                'name' => $req->name
            ]);
        } else {
            //Create
            $obj = Language::create([
                'name' => $req->name,
            ]);
            $imageUpdateId = $obj->id;
        }

        if ($req->file()) {
            $imageName = time() . '.' . $req->image->extension();
            $req->image->move(public_path('uploads/language'), $imageName);
            Language::whereId($imageUpdateId)->update([
                'image' => $imageName
            ]);
        }
        return redirect(route('language.list'));
    }


    public function job_list()
    {

        $obj = Vacancy::all();

        return view('admin.pages.job_vacancy.job_list', compact('obj'));
    }
    public function job_detail(Request $req)
    {
        $obj = Vacancy::whereId($req->id)->first();
        echo view('admin.pages.job_vacancy.detail', compact('obj'));
    }

    public function business_list()
    {

        $obj = Business::all();

        return view('admin.pages.business.index', compact('obj'));
    }
    public function business_detail(Request $req)
    {
        $obj = Business::whereId($req->id)->first();
        echo view('admin.pages.business.detail', compact('obj'));
    }
}
